% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_metropolis.R
\name{bv_mh}
\alias{bv_mh}
\title{Metropolis-Hastings settings}
\usage{
bv_mh(scale_hess = 0.01, adjust_acc = FALSE, acc_lower = 0.25,
  acc_upper = 0.35, acc_change = 0.01)
}
\arguments{
\item{scale_hess}{Numeric scalar. Scaling parameter, determining the range
of hyperparameter draws. \emph{Should be calibrated so a reasonable rate of
acceptance is reached}.}

\item{adjust_acc}{Logical scalar. Whether or not to further scale the
variability of parameter draws during the burn-in phase. See details.}

\item{acc_lower}{Numeric scalar. Lower bound of the target acceptance rate.
Required if adjust_acc is set to \code{TRUE}.}

\item{acc_upper}{Numeric scalar. Upper bound of the target acceptance rate.
Required if adjust_acc is set to \code{TRUE}.}

\item{acc_change}{Numeric scalar. Percent change applied to the Hessian
matrix. Required if adjust_acc is set to \code{TRUE}.}
}
\value{
Returns a named list of class \code{bv_metropolis} with options for
\code{\link{bvar}}.
}
\description{
Function to provide settings for the Metropolis-Hastings step in
\code{\link{bvar}}. Options include scaling the inverse Hessian that
is used to draw parameter proposals and automatic scaling to
achieve a certain acceptance rate.
}
\examples{
# Only adjust the scale parameter
bv_mh(scale_hess = 10)

# Turn on automatic scaling of the acceptance rate to [20\%, 40\%]
bv_mh(adjust_acc = TRUE, acc_lower = 0.2, acc_upper = 0.4)
}
