% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.setBurnin}
\alias{mcmc.setBurnin}
\title{(Re-)set burnin of MCMC chains.}
\usage{
mcmc.setBurnin(draws, burnin)
}
\arguments{
\item{draws}{MCMC draws as returned by \code{*.mcmc.DrawParameters}}

\item{burnin}{New start index.}
}
\value{
2-element list with MCMC draws
}
\description{
(Re-)set burnin of MCMC chains.
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
param.draws <- pnbd.mcmc.DrawParameters(cbs,
  mcmc = 100, burnin = 50, thin = 10, chains = 1) # short MCMC to run demo fast
param.draws.stable <- mcmc.setBurnin(param.draws, burnin = 80)
}
