% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.PlotTransactionRateHeterogeneity}
\alias{bgnbd.PlotTransactionRateHeterogeneity}
\title{BG/NBD Plot Transaction Rate Heterogeneity}
\usage{
bgnbd.PlotTransactionRateHeterogeneity(params, lim = NULL)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that
order. r and alpha are unobserved parameters for the NBD transaction
process. a and b are unobserved parameters for the Beta geometric dropout
process.}

\item{lim}{upper-bound of the x-axis. A number is chosen by the function if
none is provided.}
}
\value{
Distribution of customers' propensities to purchase.
}
\description{
Plots and returns the estimated gamma distribution of lambda (customers'
propensities to purchase).
}
\details{
This returns the distribution of each customer's Poisson parameter, which
determines the rate at which each customer buys.
}
\examples{
params <- c(0.243, 4.414, 0.793, 2.426)
bgnbd.PlotTransactionRateHeterogeneity(params)
params <- c(0.53, 4.414, 0.793, 2.426)
bgnbd.PlotTransactionRateHeterogeneity(params)
}
