% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTLLasso-package.R
\docType{data}
\name{Buli1516}
\alias{Buli1516}
\title{Bundesliga Data 2015/16 (Buli1516)}
\format{
A list containing data from the German Bundesliga with 306 observations. 
The list contains both information on the response (paired comparisons) and different covariates.
\describe{ 
\item{Y5}{A response.BTLLasso object with 5 response categories for the Buli1516 data including
\itemize{
\item{response: Ordinal paired comparison response vector} 
\item{first.object: Vector containing the first-named team per paired comparison (home team)}
\item{second.object: Vector containing the second-named team per paired comparison (away team)}
\item{subject: Vector containing a match-day identifier per paired comparison}
\item{with.order} Vector containing information that each match has to be considered including an order effect.
}}
\item{Y3}{A response.BTLLasso object with 3 response categories for the Buli1516 data including
\itemize{
\item{response: Ordinal paired comparison response vector} 
\item{first.object: Vector containing the first-named team per paired comparison (home team)}
\item{second.object: Vector containing the second-named team per paired comparison (away team)}
\item{subject: Vector containing a match-day identifier per paired comparison}
\item{with.order} Vector containing information that each match has to be considered including an order effect.
}}
\item{Z1}{Matrix containing all team-match-specific covariates
\itemize{
\item{Distance: Total amount of km run} 
\item{BallPossession: Percentage of ball possession}
\item{TacklingRate: Rate of won tacklings}
\item{ShotsonGoal: Total number of shots on goal} 
\item{CompletionRate: Percentage of passes reaching teammates} 
\item{FoulsSuffered: Number of fouls suffered} 
\item{Offside: Number of offsides (in attack)}
}
}
\item{Z2}{Matrix containing all the average market values of the teams as a team-specific covariate} 
}
 @references Schauberger, Gunther and Tutz, Gerhard (2019): BTLLasso - A Common Framework and Software 
Package for the Inclusion  and Selection of Covariates in Bradley-Terry Models, \emph{Journal of 
Statistical Software}, to appear

Schauberger, Gunther and Tutz, Gerhard (2017): Subject-specific modelling 
of paired comparison data: A lasso-type penalty approach, \emph{Statistical Modelling},
17(3), 223 - 243

Schauberger, Gunther, Groll Andreas and Tutz, Gerhard (2018): 
Analysis of the importance of on-field covariates in the German Bundesliga, 
\emph{Journal of Applied Statistics}, 45(9), 1561 - 1578
}
\source{
\url{https://www.kicker.de/}
}
\description{
Data from the German Bundesliga from the season 2015/16. 
The data contain all 306 matches of the season treated as paired comparisons with  5 (Y5) or 3 (Y3) different 
response categories. Additionally, different match-specific covariates are given as, for example, 
the percentage of ball possession or the total running distance per team and per match.
}
\examples{
\dontrun{
op <- par(no.readonly = TRUE)

data(Buli1516)

Y <- Buli1516$Y5
Z1 <- scale(Buli1516$Z1, scale = FALSE)

ctrl.buli <- ctrl.BTLLasso(object.order.effect = TRUE, 
                           name.order = "Home", 
                           penalize.order.effect.diffs = TRUE, 
                           penalize.order.effect.absolute = FALSE,
                           order.center = TRUE, lambda2 = 1e-2)

set.seed(1860)
m.buli <- cv.BTLLasso(Y = Y, Z1 = Z1, control = ctrl.buli)
m.buli

par(xpd = TRUE, mar = c(5,4,4,6))
plot(m.buli)

par(op)
}
}
\seealso{
\code{\link{Buli1415}}, \code{\link{Buli1617}}, \code{\link{Buli1718}}
}
\keyword{datasets}
