% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.BTLLasso.R
\name{response.BTLLasso}
\alias{response.BTLLasso}
\title{Create response object for BTLLasso}
\usage{
response.BTLLasso(response, first.object = NULL, second.object = NULL,
  subject = NULL, with.order = rep(TRUE, length(response)))
}
\arguments{
\item{response}{Vector containing results (binary or ordinal) of single paired
comparisons. Alternatively, also a  \code{\link[psychotools]{paircomp}} object as defined 
in the package \code{psychotools} could be used. In this case, none of the further 
arguments are needed.}

\item{first.object}{Vector (character or factor, same length as response) indicating the first
object of the respective paired comparison from response.}

\item{second.object}{Vector (character or factor, same length as response) indicating the second
object of the respective paired comparison from response.}

\item{subject}{Vector (character, same length as response) indicating the subject that
generated the respective paired comparison from response.}

\item{with.order}{Boolean vector containing indicators for each paired comparison if an order effect was 
present. By default, an order effect is assumed for each comparison. This option is relevant whenever 
only some of the paired comparisons had an order effect and others did not, for example if some matches are
played on neutral ground. This option is only effective if either \code{order.effect = TRUE} or \code{object.order.effect = TRUE}.}
}
\value{
Object of class \code{response.BTLLasso}
}
\description{
Create a response object for \code{BTLLasso} and \code{cv.BTLLasso}
}
\examples{

\dontrun{
##############################
##### Example how response object for Bundesliga data Buli1516 was created
##############################

data(BuliResponse)

Y.Buli <- response.BTLLasso(response = BuliResponse$Result, 
                            first.object = BuliResponse$TeamHome,
                            second.object = BuliResponse$TeamAway,
                            subject = BuliResponse$Matchday)


##############################
##### Example to create response object from paircomp object
##############################
data("Topmodel2007", package = "psychotree")

Y.models <- response.BTLLasso(Topmodel2007$preference)
X.models <- scale(model.matrix(preference~., data = Topmodel2007)[,-1])
rownames(X.models) <- paste0("Subject",1:nrow(X.models))
colnames(X.models) <- c("Gender","Age","KnowShow","WatchShow","WatchFinal")

set.seed(5)
m.models <- cv.BTLLasso(Y = Y.models, X = X.models)
}
}
\references{
Schauberger, Gunther and Tutz, Gerhard (2019): BTLLasso - A Common Framework and Software 
Package for the Inclusion  and Selection of Covariates in Bradley-Terry Models, \emph{Journal of 
Statistical Software}, 88(9), 1-29, \url{http://doi.org/10.18637/jss.v088.i09}

Schauberger, Gunther and Tutz, Gerhard (2017): Subject-specific modelling 
of paired comparison data: A lasso-type penalty approach, \emph{Statistical Modelling},
17(3), 223 - 243

Schauberger, Gunther, Groll Andreas and Tutz, Gerhard (2018): 
Analysis of the importance of on-field covariates in the German Bundesliga, 
\emph{Journal of Applied Statistics}, 45(9), 1561 - 1578
}
\seealso{
\code{\link{BTLLasso}}, \code{\link{cv.BTLLasso}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}
}
