% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_toad}
\alias{sim_toad}
\title{The simulation function for the toad example}
\usage{
sim_toad(params, ntoad, nday, model = 1L, d0 = 100)
}
\arguments{
\item{params}{A vector of proposed model parameters, \ifelse{html}{\out{<i>&#945</i>}}{\eqn{\alpha}},
\ifelse{html}{\out{<i>&#947</i>}}{\eqn{gamma}} and \ifelse{html}{\out{p<sub>0</sub>}}{\eqn{p_0}}.}

\item{ntoad}{The number of toads to simulate in the observation.}

\item{nday}{The number of days lasted of the observation.}

\item{model}{Which model to be used. 1 for the random return model, 2 for the nearest return model,
and 3 for the distance-based return probability model.}

\item{d0}{Characteristic distance for model 3. Only used if model is 3.}
}
\value{
A data matrix.
}
\description{
The simulation function for the toad example.
}
\examples{
sim_toad(c(1.7,36,0.6), 10, 8, 1)
}
