% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brvm-company-rank.R
\name{BRVM_company_rank}
\alias{BRVM_company_rank}
\title{BRVM Companies Rank - Get all tickers rank according to last quotation}
\usage{
BRVM_company_rank()
}
\value{
"tbl_df"     "tbl"        "data.frame"
}
\description{
This function returns companies rank from the BRVM Bourse exchange according to their daily change (variation).
}
\details{
This function will get the rank of the companies listed on the BVRM exchange through the Rich Bourse site.
The function takes no parameter
}
\examples{

BRVM_company_rank()
comp.rank<-BRVM_company_rank()
comp.rank<-comp.rank\%>\%
dplyr::arrange(desc(percent_change))
comp.rank


}
\seealso{
\url{https://www.brvm.org/en/cours-actions/0}

Other Data Retrieval: 
\code{\link{BRVM_bySector}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_get1}()},
\code{\link{BRVM_get}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()}

Other BRVM: 
\code{\link{BRVM.index}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_cap}()},
\code{\link{BRVM_company_url}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{BRVM_traded_val}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()},
\code{\link{normality_test}()},
\code{\link{stationarity_test}()}
}
\author{
Koffi Frederic SESSIE

Oudouss Diakité Abdoul

Steven P. Sanderson II, MPH
}
\concept{BRVM}
\concept{Data Retrieval}
