% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BRACoD.R
\name{summarize_trace}
\alias{summarize_trace}
\title{Summarize the results of BRACoD}
\usage{
summarize_trace(trace, bug_names = NULL, cutoff = 0.3)
}
\arguments{
\item{trace}{the pymc3 object that is the output of run_bracod()}

\item{bug_names}{optional, a list of names of the bacteria to include in the results}

\item{cutoff}{this is the cutoff on the average inclusion for inclusion}
}
\value{
a dataframe with information about the bacteria that BRACoD identified
}
\description{
This summarizes the trace object that run_bracod() returns. It returns a dataframe
that contains two parameters of interest, the average inclusion (p) and the average
coefficient (beta), telling you the association between that bacteria and the environmental
variable
}
\examples{
\dontrun{
trace <- run_bracod(sim_relab, sim_y, n_sample = 1000, n_burn=1000, njobs=4)
df_summary <- summarize_trace(trace, colnames(sim_relab))
}
}
