% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test}
\alias{test}
\alias{grad_test_bp}
\alias{grad_test_ga}
\alias{grad_test_ig}
\alias{grad_test_wei}
\alias{grad_test_rbs}
\alias{wald_test_bp}
\alias{wald_test_ga}
\alias{wald_test_ig}
\alias{wald_test_wei}
\alias{score_test_bp}
\alias{score_test_ga}
\alias{score_test_ig}
\alias{score_test_wei}
\alias{score_test_rbs}
\alias{dRBS}
\alias{wald_test}
\title{Precision test}
\usage{
grad_test_bp(modelh0,modelh1)

grad_test_ga(modelh0, modelh1)

grad_test_ig(modelh0, modelh1)

grad_test_wei(modelh0, modelh1)

dRBS(x, mu = 1, sigma = 1, log = FALSE)

score_test_bp(modelh0, modelh1)

score_test_rbs(modelh0, modelh1)

score_test_ga(modelh0, modelh1)

score_test_ig(modelh0, modelh1)

score_test_wei(modelh0, modelh1)

wald_test(modelh1)
}
\arguments{
\item{modelh0}{model under null hypothesis.}

\item{modelh1}{model under alternative hypothesis.}

\item{x}{vector of quantiles.}

\item{mu, sigma}{the (positive) location and precision parameter.}

\item{log}{logical; The logarithm of the density is returned if the value is
TRUE.}
}
\value{
A list with class "htest" containing the following components:

\code{statistic}	the value of the test statistic.

\code{parameter}	the degrees of freedom for the test statistic.

\code{p.value}	the p-value for the test.

\code{method}	a character string indicating what type of likelihood
ratio test was performed.

\code{data.name} a character string giving the name(s) of the data
}
\description{
Tests the null hypothesis of precision fixed in RBS models
against the alternative of precision variable.
}
\author{
Manoel Santos-Neto \email{manoelferreira@uaest.ufcg.edu.br}
}
