% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codes.R
\name{diag.BP}
\alias{diag.BP}
\alias{diag.GA}
\alias{diag.IG}
\alias{diag.WEI}
\alias{res_pearson}
\title{Diagnostic Analysis - Local Influence}
\usage{
diag.BP(model, mu.link = "log", sigma.link = "log", scheme = "case.weight")

diag.GA(
  model,
  mu.link = "log",
  sigma.link = "identity",
  scheme = "case.weight"
)

diag.IG(
  model,
  mu.link = "log",
  sigma.link = "identity",
  scheme = "case.weight"
)

diag.WEI(
  model,
  mu.link = "log",
  sigma.link = "identity",
  scheme = "case.weight"
)

res_pearson(model)
}
\arguments{
\item{model}{Object of class \code{gamlss} holding the fitted model.}

\item{mu.link}{Defines the mu.link, with "identity" link as the default for
the mu parameter.}

\item{sigma.link}{Defines the sigma.link, with "identity" link as the default
for the sigma parameter.}

\item{scheme}{Default is "case.weight". But, can be "response".}
}
\value{
Local influence measures.
}
\description{
Diagnostics for the BP, GA, IG and WEI regression models
}
\references{
Bourguignon, M., Santos-Neto, M. and Castro, M. A new regression model for
positive random variables with skewed and long tail. \emph{METRON},
v. 79, p. 33--55, 2021. \doi{http://dx.doi.org/10.1007/s40300-021-00203-y}
}
\author{
Manoel Santos-Neto \email{manoel.ferreira at professor.ufcg.edu.br}
}
