% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{getJacobian_wrap}
\alias{getJacobian_wrap}
\title{Calculating the Jacobian for a given set of non-linear parameters and mean utilities.}
\usage{
getJacobian_wrap(blp_data, par_theta2, printLevel = 2)
}
\arguments{
\item{blp_data}{data object created by the function \code{BLP_data},}

\item{par_theta2}{matrix with column and rownames providing the evaluation point (see details),}

\item{printLevel}{level of output information ranges from 1 (no GMM results) to 4 (every norm in the contraction mapping)}
}
\value{
Returns a matrix with the jacobian (products in rows, parameters in columns).
}
\description{
Calculating the Jacobian for a given set of non-linear parameters and mean utilities.
}
\details{
NA's in \code{par_theta2} entries indicate the exclusion from estimation, i.e. the coefficient is assumed to be zero.
If only unobserved heterogeneity is used (no demographics), the column name of \code{par_theta2} must be "unobs_sd".
With demographics the colnames must match the names of provided demographics (as in \code{demographic_draws}) and "unobs_sd".
Row names of \code{par_theta2} must match random coefficients as specified in \code{model}. Constants must be named "(Intercept)".
}
\examples{
K<-2 #number of random coefficients
data <- get_BLP_dataset(nmkt = 25, nbrn = 20,
                        Xlin = c("price", "x1", "x2", "x3", "x4", "x5"),
                        Xexo = c("x1", "x2", "x3", "x4", "x5"),
                        Xrandom = paste0("x",1:K),instruments = paste0("iv",1:10),
                        true.parameters = list(Xlin.true.except.price = rep(0.2,5),
                                               Xlin.true.price = -0.2,
                                               Xrandom.true = rep(2,K),
                                               instrument.effects = rep(2,10),
                                               instrument.Xexo.effects = rep(1,5)),
                        price.endogeneity = list( mean.xi = -2,
                                                  mean.eita = 0,
                                                  cov = cbind( c(1,0.7), c(0.7,1))),
                        printlevel = 0, seed = 234234 )


model <- as.formula("shares ~  price + x1 + x2 + x3 + x4 + x5 |
                    x1 + x2 + x3 + x4 + x5 |
                    0+ x1 + x2 |
                    iv1 + iv2 + iv3 + iv4 + iv5 + iv6 + iv7 + iv8 +iv9 +iv10" )

blp_data <- BLP_data(model = model, market_identifier="cdid",
                     product_id = "prod_id",
                     productData = data,
                     integration_method = "MLHS" ,
                     integration_accuracy = 40,
                     integration_seed = 1)

theta_guesses <- matrix(c(0.5,2), nrow=2)
rownames(theta_guesses) <- c("x1","x2")
colnames(theta_guesses) <- "unobs_sd"

jacobian <- getJacobian_wrap(blp_data=blp_data,
                             par_theta2 = theta_guesses,
                             printLevel = 2)
head(jacobian)
}
