% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateAUCwithCMLperTimePoint.R
\encoding{UTF-8}
\name{estimateAUCwithCMLperTimePoint}
\alias{estimateAUCwithCMLperTimePoint}
\title{estimate AUC with censored maximum likelihood per time point}
\usage{
estimateAUCwithCMLperTimePoint(
  inputData,
  LOQ,
  timePoints,
  isMultiplicative = FALSE,
  onlyFitCML = FALSE,
  printCMLmessage = TRUE,
  optimizationMethod = NULL,
  CMLcontrol = NULL
)
}
\arguments{
\item{inputData}{numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
 the input dataset}

\item{LOQ}{scalar, limit of quantification value}

\item{timePoints}{vector of time points}

\item{isMultiplicative}{logical variable indicating whether
an additive error model (FALSE) or a multiplicative error
model (TRUE) should be used}

\item{onlyFitCML}{logical variable with FALSE as default, if TRUE only the
censored maximum likelihood estimates will be calculated}

\item{printCMLmessage}{logical variable with TRUE as default, if TRUE then
messages regarding the convergence status of censored 
log-likelihood maximization will be printed.}

\item{optimizationMethod}{single string specifying the method to be used for optimizing the log-likelihood, 
the default is NULL that allows the function to decide the about the best method. Otherwise, one can select among choices
available via R package maxLik: "NR" (for Newton-Raphson), "BFGS" (for Broyden-Fletcher-Goldfarb-Shanno), 
"BFGSR" (for the BFGS algorithm implemented in R), 
"BHHH" (for Berndt-Hall-Hall-Hausman), "SANN" (for Simulated ANNealing), 
"CG" (for Conjugate Gradients), or "NM" (for Nelder-Mead). 
Lower-case letters (such as "nr" for Newton-Raphson) are allowed.}

\item{CMLcontrol}{list of arguments to control 
convergence of maximization algorithm. It is the same argument
as control in the function maxLik in the R package maxLik}
}
\value{
a list with three components: output of maxLik function,
estimated parameters for 
each column using censored maximum likelihood, and estimated
AUC and its standard error.
}
\description{
function to estimate mean and standard error of each column
of data with BLOQ's using a censored maximum likelihood (CML) approach,
then use these estimates for estimating AUC and its standard
error
}
\examples{
# generate data from Beal model with only fixed effects
set.seed(111)
genDataFixedEffects <- simulateBealModelFixedEffects(10, 0.693,
 		1, 1, seq(0.5,3,0.5))
# Multiplicative error model
estimateAUCwithCMLperTimePoint(genDataFixedEffects, 0.1, seq(0.5,3,0.5), TRUE)
}
\seealso{
\href{https://www.rdocumentation.org/packages/maxLik/versions/1.3-4/topics/maxLik}{maxLik}
}
\author{
Vahid Nassiri, Helen Yvette Barnett
}
