% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-Model.R
\name{fit}
\alias{fit}
\title{fit bkt model}
\usage{
fit(
  object,
  data_path = NULL,
  data = NULL,
  parallel = FALSE,
  seed = NULL,
  num_fits = 1,
  forgets = FALSE,
  fixed = NULL,
  model_type = NULL,
  ...
)
}
\arguments{
\item{object}{A BKT model object. The model to be cross-validated.}

\item{data_path}{Character. The file path to the dataset. This will be used if \code{data} is not provided.}

\item{data}{Data frame. The dataset to be used for cross-validation. If \code{data} is not provided,
\code{data_path} should be used to load the dataset from a file.}

\item{parallel}{Logical. Indicates whether to use parallel computation.
If set to \code{TRUE}, multithreading will be used to speed up model training.}

\item{seed}{Numeric. Seed for the random number generator, which ensures reproducibility
of results.}

\item{num_fits}{Integer. Number of fit iterations. The best model is selected from
the total iterations.}

\item{forgets}{Logical. Whether to include a forgetting factor in the model.
If set to \code{TRUE}, the model will account for the possibility that learners may forget knowledge.}

\item{fixed}{List. A nested list specifying which parameters to fix for specific skills during
model fitting. Each skill can have certain parameters, such as "guesses" and "slips", set to
\code{TRUE} (to fix) or \code{FALSE} (to let them vary). For example:
\code{list("skill_name" = list("guesses" = TRUE, "slips" = TRUE))}.}

\item{model_type}{Logical vector. Specifies model variants to use. There are four possible
variants: 'multilearn', 'multiprior', 'multipair', and 'multigs'. Each corresponds to
a different modeling strategy.}

\item{...}{Other parameters.}
}
\value{
A fitted BKT model object, which can be used for predictions, cross-validation,
or parameter analysis.
}
\description{
Fit a BKT (Bayesian Knowledge Tracing) model.
This function fits the BKT model using the provided data and various options, such as
skill filtering, forget model, and parallelization. The function uses the model object
created by \code{bkt()} and fits the data according to the specified parameters.
}
\examples{
\donttest{
model <- bkt(seed = 42, parallel = FALSE, num_fits = 1)
result <- fit(
  model,
  data_path = "data.csv"
)
}
}
