% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreVisits.r
\name{spatialVisits}
\alias{spatialVisits}
\title{A function to convert visits into a spatial object}
\usage{
spatialVisits(
  x,
  xyCols = c("centroidX", "centroidY"),
  dataCRS = "4326",
  radius = "medianDist"
)
}
\arguments{
\item{x}{an object of class \sQuote{data.frame} from exploreVisits.}

\item{xyCols}{a character vector with the column names for the coordinates.
Default to \code{c("centroidX","centroidY")}}

\item{dataCRS}{a character string or numeric with the original
coordinate reference system (CRS). Default to \code{4326}}

\item{radius}{either a character string with the name of the column
containing the radius of the visit circle, or a numeric vector with its value
in meters. Default to \code{"medianDist"}}
}
\value{
a list with the centroids and a the effort circles. Note that when plotted
directly effort circles may not look like circles in the returned
(Pseudo-Mercator) projection.
}
\description{
A function to convert visits into a spatial object
}
\examples{
\donttest{
# create a visit-based data object from the original observation-based data
library(sf)
OB <- organizeBirds(bombusObsShort)
visitStats<-exploreVisits(OB)
spV<-spatialVisits(visitStats)
plot(spV$effort$geometry)
}
}
\seealso{
\code{\link{exploreVisits}}, \code{\link{organiseBirds}}
}
