% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreVisits.r
\name{exploreVisits}
\alias{exploreVisits}
\title{A function to explore the definition of field visits}
\usage{
exploreVisits(x, visitCol = NULL, sppCol = "scientificName")
}
\arguments{
\item{x}{an object of class \sQuote{OrganizedBirds} (organised BIRDS Spatial Dataframe).
See \code{\link{organizeBirds}}.}

\item{visitCol}{name of the column for the visits UID.}

\item{sppCol}{name of the column for species names.}
}
\value{
a \code{data.frame} with summarized data per visit:
\itemize{
  \item \dQuote{day}
  \item \dQuote{month}
  \item \dQuote{year}
  \item \dQuote{nObs}: number of species observations
  \item \dQuote{SLL}: species list length (i.e. the number of observed species)
  \item \dQuote{effortDiam}: the 2 times the maximum of the distances between
  the centroid of all observation points and any individual observation.
  \item \dQuote{medianDist}: the median (Q2) of the distances between the
  centroid and the observations, in meters.
  \item \dQuote{iqrDist}: the interquartile range of the distances between the
   centroid the observations, in meters.
  \item \dQuote{nUniqueLoc}: the number of unique combination of coordinates (locations).
  \item \dQuote{nClusters}: the number of clusters defined by the DBSCAN algorithm,
  a minimum of 3 observations per cluster within the median distance between
  all observations. If the number of clusters is = 0 means that there are at
  least 3 unique locations but observations are too spread and no cluster was
  found. If the number of unique locations is less than 3, observations are
  considered as a single cluster without outliers.
  \item \dQuote{nOutliers}: the number of observations whose distance to any
  cluster is beyond the median distance between all observations.
}
}
\description{
A function to explore the definition of field visits. Visits are a central concept
in the approach to species observation data used by the BIRDS package. In order to assess if your
definition of visit aligns with your grid size, you must explore the spatial extent of visits.
}
\examples{
if(interactive()){
# create a visit-based data object from the original observation-based data
OB <- organizeBirds(bombusObs)
visitStats <- exploreVisits(OB)
esquisse::esquisser(visitStats)
# alternatively, plot the variable you want, e.g.:
# to see the distribution of distances covered on each visit
hist(visitStats$effortDiam)
# to see the distribution of species list lengths of each visit
hist(visitStats$SLL)
# to identify suspicious visits reported the first day of each month or year
hist(visitStats$day)
# to see correlations
plot(visitStats$nObs, visitStats$effortDiam)
plot(visitStats$SLL, visitStats$effortDiam)
# to see the ditributions of observations along the days of the month
plot(visitStats$day, visitStats$nObs)
}
}
\seealso{
\code{\link{createVisits}}, \code{\link{organiseBirds}}
}
