% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctTaxo.R
\name{correctTaxo}
\alias{correctTaxo}
\title{This function corrects typos for a given taxonomic name using the Taxonomic Name Resolution Service (TNRS).}
\usage{
correctTaxo(
  genus,
  species = NULL,
  score = 0.5,
  useCache = FALSE,
  verbose = TRUE,
  accepted = FALSE
)
}
\arguments{
\item{genus}{Vector of genera to be checked. Alternatively, the whole species name (genus + species)
or (genus + species + author) may be given (see example).}

\item{species}{(optional) Vector of species to be checked (same size as the genus vector).}

\item{score}{Score of the matching (see https://tnrs.biendata.org/instructions/) below which corrections are discarded.}

\item{useCache}{logical. Whether or not use a cache to reduce online search of taxa names (NULL means use cache but clear it first)}

\item{verbose}{logical. If TRUE various messages are displayed during process}

\item{accepted}{logical. If TRUE accepted names will be returned instead of matched names. Cache will not be used as synonymy changes over time.}
}
\value{
The function returns a dataframe with the corrected (or not) genera and species.
}
\description{
This function corrects typos for a given taxonomic name using the Taxonomic Name Resolution Service (TNRS).
}
\details{
This function create a file named correctTaxo.log (see Localisation), this file have the memory of all the previous requests, as
to avoid the replication of time-consuming server requests.

By default, names are queried in batches of 500, with a 0.5s delay between each query. These values can be modified using options:
\code{options(BIOMASS.batch_size=500)} for batch size (max 1000), \code{options(BIOMASS.wait_delay=0.5)} for delay (in seconds).
}
\section{Localisation}{

Cache path discovery protocol
\enumerate{
\item BIOMASS.cache option set to an \strong{existing} folder
\item \strong{existing} user data folder \code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}
\itemize{
\item On Linux : \verb{~/.local/share/R/BIOMASS}
\item On Mac OS X : \verb{~/Library/Application Support/R/BIOMASS}
\item On Windows 7 up to 10 : \verb{C:\\\\Users\\\\<username>\\\\AppData\\\\Local\\\\R\\\\BIOMASS}
\item On Windows XP : \verb{C:\\\\Documents and Settings\\\\<username>\\\\Data\\\\R\\\\BIOMASS}
}
\item fallback to R session tempdir
}
}

\examples{
\donttest{
correctTaxo(genus = "Astrocarium", species = "standleanum")
correctTaxo(genus = "Astrocarium standleanum")
}

}
\references{
Boyle, B. et al. (2013).
\emph{The taxonomic name resolution service: An online tool for automated standardization of plant names}. BMC bioinformatics, 14, 1. doi:10.1186/1471-2105-14-16
}
\author{
Ariane TANGUY, Arthur PERE, Maxime REJOU-MECHAIN, Guillaume CORNU
}
