% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_family}
\alias{BIEN_trait_family}
\title{Download trait data for given families.}
\usage{
BIEN_trait_family(family, print.query = FALSE, ...)
}
\arguments{
\item{family}{A single family or a vector of families.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
A dataframe of all data matching the specified families.
}
\description{
BIEN_trait_family extracts all trait data for the specified families.
}
\examples{
\dontrun{
BIEN_trait_family("Poaceae")
family_vector<-c("Poaceae","Orchidaceae")
BIEN_trait_family(family_vector)}
}
\seealso{
Other trait functions: \code{\link{BIEN_trait_list}},
  \code{\link{BIEN_trait_mean}},
  \code{\link{BIEN_trait_species}},
  \code{\link{BIEN_trait_traitbyfamily}},
  \code{\link{BIEN_trait_traitbygenus}},
  \code{\link{BIEN_trait_traitbyspecies}},
  \code{\link{BIEN_trait_traits_per_species}},
  \code{\link{BIEN_trait_trait}}
}

