% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_load_species}
\alias{BIEN_ranges_load_species}
\title{Load range maps for specified species.}
\usage{
BIEN_ranges_load_species(species, print.query = FALSE, ...)
}
\arguments{
\item{species}{A single species or a vector of species.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
A SpatialPolygonsDataFrame containing range maps for the specified species.
}
\description{
BIEN_ranges_load_species returns spatial data for the specified species.
}
\examples{
\dontrun{
species_vector<-c("Abies_lasiocarpa","Abies_amabilis")
abies_maps<-BIEN_ranges_load_species(species = species_vector)
xanthium_strumarium<-BIEN_ranges_load_species(species = "Xanthium strumarium")

#Plotting files
plot(abies_maps)#plots the shapefile, but doesn't mean much without any reference
require(maps) #easy source of maps
map('world', fill = TRUE, col = "grey")#plots a world map (WGS84 projection), in grey
plot(xanthium_strumarium,col="forest green",add=TRUE) #adds the range of X. strumarium
plot(abies_maps[1,], add = T, col ="light green")}
}
\seealso{
Other range functions: \code{\link{BIEN_ranges_box}},
  \code{\link{BIEN_ranges_genus}},
  \code{\link{BIEN_ranges_intersect_species}},
  \code{\link{BIEN_ranges_shapefile}},
  \code{\link{BIEN_ranges_species}}
}

