% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSex.R
\name{checkSex}
\alias{checkSex}
\title{Validates and Optionally Repairs Sex Coding in a Pedigree Dataframe}
\usage{
checkSex(
  ped,
  code_male = NULL,
  code_female = NULL,
  verbose = FALSE,
  repair = FALSE
)
}
\arguments{
\item{ped}{A dataframe representing the pedigree data with a 'sex' column.}

\item{code_male}{The current code used to represent males in the 'sex' column. At least one is needed.}

\item{code_female}{The current code used to represent females in the 'sex' column. If both male and female are NULL, no recoding is performed.}

\item{verbose}{A logical flag indicating whether to print progress and validation messages to the console.}

\item{repair}{A logical flag indicating whether to attempt repairs on the sex coding.}
}
\value{
Depending on the value of `repair`, either a list containing validation results or a repaired dataframe is returned.
}
\description{
This function performs two main tasks:
1. Optionally recodes the 'sex' variable based on a given code for males.
2. Optionally repairs the sex coding based on a specified logic.
}
\examples{
\dontrun{
ped <- data.frame(ID = c(1, 2, 3), sex = c("M", "F", "M"))
checkSex(ped, code_male = "M", verbose = TRUE, repair = FALSE)
}
}
