% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpo.R
\name{cpo}
\alias{cpo}
\title{Conditional Predictive Ordinate (CPO) Statistic}
\usage{
cpo(res)
}
\arguments{
\item{res}{tibble. The output from the *Res functions, where * could either
be BeM, GaM, CGaM, CuM, CCuM}
}
\value{
\item{LPML}{The value of the logarithm of the Pseudomarginal likelihood}
\item{plot}{CPO Plot} %% ...
}
\description{
Makes the CPO Plot and calculates the logarithm of the Pseudomarginal
likelihood (LPML).
}
\details{
Computes de CPO as a goodness of fit measure
}
\examples{



## Example 1
#  data(gehan)
#  timesG <- gehan$time[gehan$treat == "6-MP"]
#  deltaG <- gehan$cens[gehan$treat == "6-MP"]
#  GEX1 <- GaMRes(timesG, deltaG, K = 8, iterations = 3000)
#  cpo(GEX1)



}
\references{
See Geisser (1993); Gelfand, Dey, and Chang (1992); Dey, Chen,
and Chang (1997); and Sinha and Dey (1997)
}
