% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.data.frame.R
\name{get.data.frame}
\alias{get.data.frame}
\title{Get a BETS series as a data.frame.}
\usage{
get.data.frame(code, ts = NULL)
}
\arguments{
\item{code}{An \code{integer}. The unique identifier of the series within the BETS database.}

\item{ts}{An \code{ts} object. A time series to be formatted as a data.frame.}
}
\value{
A \code{data.frame}. The first column contains the dates. The second, its values.
}
\description{
By default, \code{\link{BETS.get}} returns a \code{\link[stats]{ts}} object. However, there are many situations in which is more convenient to work with a data.frame. So, \code{get.data.frame} receives the code of a BETS series and returns a \code{\link[base]{data.frame}} containing the data of the corresponding series. Alternatively, a \code{ts} can be supplied, in which case the BETS databases will not be searched.
}
\author{
Talitha Speranza \email{talitha.speranza@fgv.br}
}
