\docType{package}
\name{BEDMatrix-package}
\alias{BEDMatrix-package}
\title{A Package to Extract Genotypes from a PLINK .bed File}
\description{
    The \code{BEDMatrix} package provides a matrix-like wrapper around
    \href{https://www.cog-genomics.org/plink2/formats#bed}{.bed} files, one of
    the genotype/phenotype file formats of
    \href{https://www.cog-genomics.org/plink2}{PLINK}, the whole genome
    association analysis toolset. \code{BEDMatrix} objects are created by
    simply providing the path to a .bed file and once created, they behave
    similarly to regular matrices with the advantage that genotypes are
    retrieved on demand without loading the entire file into memory. This
    allows handling of very large files with limited use of memory.
}
\section{.bed Files}{
    \href{https://www.cog-genomics.org/plink2/formats#bed}{.bed} files
    (sometimes referred to as binary .ped files) are binary representations of
    genotype calls at biallelic variants. This very compact file format (2 bits
    per genotype call) is used and generated by
    \href{https://www.cog-genomics.org/plink2/}{PLINK}. .bed files should not
    be confused with the
    \href{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}{UCSC Genome
    Browser's BED format}, which is totally different.

    A .bed file can be created from a
    \href{https://www.cog-genomics.org/plink2/formats#ped}{.ped} file with
    \href{https://www.cog-genomics.org/plink2}{PLINK} using \code{plink --file
    myfile --make-bed}.
}
\seealso{
    \code{\link{BEDMatrix-class}} to learn more about the \code{BEDMatrix}
    class.
}
\keyword{package}
