% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guessIdScope.R
\name{guessIdScope}
\alias{guessIdScope}
\alias{guessIdOrigin}
\title{Guess biological entity (BE), database source and organism of a vector
of identifiers.}
\usage{
guessIdScope(ids, be, source, organism, tcLim = 100)

guessIdOrigin(...)
}
\arguments{
\item{ids}{a character vector of identifiers}

\item{be}{one BE or "Probe". \strong{Guessed if not provided}}

\item{source}{the BE ID database or "Symbol" if BE or
the probe platform if Probe. \strong{Guessed if not provided}}

\item{organism}{organism name. \strong{Guessed if not provided}}

\item{tcLim}{number of identifiers to check to guess origin for the whole set.
Inf ==> no limit.}

\item{...}{params for \code{guessIdScope}}
}
\value{
A list (NULL if no match):
\itemize{
\item \strong{be}: a character vector of length 1 providing the best BE guess
(NA if inconsistent with user input: be, source or organism)
\item \strong{source}: a character vector of length 1 providing the best source
guess (NA if inconsistent with user input: be, source or organism)
\item *\emph{organism}$: a character vector of length 1 providing the best organism
guess (NA if inconsistent with user input: be, source or organism)
}

The "details" attribute (`attr(x, "details")``) is a data frame providing
numbers supporting the guess
}
\description{
Guess biological entity (BE), database source and organism of a vector
of identifiers.
}
\section{Functions}{
\itemize{
\item \code{guessIdOrigin}: Deprecated version of guessIdScope
}}

\examples{
\dontrun{
guessIdScope(ids=c("10", "100"))
}

}
