% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_xxx.R
\name{compute_IB}
\alias{compute_IB}
\title{Compute Incremental Benefit}
\usage{
compute_IB(df_ce, k)
}
\arguments{
\item{df_ce}{Dataframe of cost and effectiveness deltas}

\item{k}{Vector of willingness to pay values}
}
\value{
Array with dimensions (k x sim x ints)
}
\description{
Sample of incremental net monetary benefit for each
willingness-to-pay threshold, \eqn{k}, and comparator.
}
\details{
Defined as:

\deqn{IB = u(e,c; 1) - u(e,c; 0).}

If the net benefit function is used as utility function,
the definition can be re-written as

\deqn{IB = k\cdot\Delta_e - \Delta_c.}
}
\seealso{
\code{\link{compute_EIB}}
}
