% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trajplot.R
\name{trajplot}
\alias{trajplot}
\title{Trajplot for fitted model}
\usage{
trajplot(
  fit,
  feature.ind = 1,
  which.cluster = "global.cluster",
  title = NULL,
  ylab = NULL,
  xlab = NULL,
  color = NULL
)
}
\arguments{
\item{fit}{an objective output from BCC.multi() function}

\item{feature.ind}{a numeric value indicating which feature to plot.
The number indicates the order of the feature specified
in mydat argument of the BCC.multi()() function}

\item{which.cluster}{a character value: "global" or "local", indicating
whether to plot the trajectory by global cluster or
local cluster indices}

\item{title}{Title for the trace plot}

\item{ylab}{Label for y axis}

\item{xlab}{Label for x axis}

\item{color}{Color for the trajplot}
}
\value{
void function with no return value, only show plots
}
\description{
plot the longitudinal trajectory of features by local and global clusterings
}
\examples{
# get data from the package
filePath <- system.file("extdata", "epil1.rds", package = "BCClong")
fit.BCC <- readRDS(filePath)
# for local cluster
trajplot(fit=fit.BCC,feature.ind=1, which.cluster = "local.cluster",
         title= "Local Clustering",xlab="time (months)",
         ylab="anxiety",color=c("#00BA38", "#619CFF"))

# for global cluster
trajplot(fit=fit.BCC,feature.ind=1,
         which.cluster = "global.cluster",
         title="Global Clustering",xlab="time (months)",
         ylab="anxiety",color=c("#00BA38", "#619CFF"))

}
