context("dropNamed")

test_that("dropNamed", {
  x = matrix(1:4, 2, 2)
  colnames(x) = c("a", "b")
  y = dropNamed(x, character(0))
  expect_equal(y, x)
  y = dropNamed(x, c("a"))
  expect_equal(y, x[, "b", drop=FALSE])
  y = dropNamed(x, c("a", "b"))
  expect_equal(y, x[, character(0)])

  x = as.data.frame(x)
  y = dropNamed(x, character(0))
  expect_equal(y, x)
  y = dropNamed(x, c("a"))
  expect_equal(y, x[, "b", drop=FALSE])
  y = dropNamed(x, c("a", "b"))
  expect_equal(y, x[, character(0)])

  x = list(a=1, b=2)
  y = dropNamed(x, character(0))
  expect_equal(y, x)
  y = dropNamed(x, c("a"))
  expect_equal(y, x["b"])
  y = dropNamed(x, c("a", "b"))
  expect_equal(y, x[character(0)])

  x = c(a=1, b=2)
  y = dropNamed(x, character(0))
  expect_equal(y, x)
  y = dropNamed(x, c("a"))
  expect_equal(y, x["b"])
  y = dropNamed(x, c("a", "b"))
  expect_equal(y, x[character(0)])
})
