% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRelativePath.R
\name{getRelativePath}
\alias{getRelativePath}
\title{Construct a path relative to another}
\usage{
getRelativePath(to, from = getwd(), ignore.case = isWindows())
}
\arguments{
\item{to}{[\code{character(1)}]\cr
Where the relative path should point to.}

\item{from}{[\code{character(1)}]\cr
From which part to start.
Default is \code{\link[base]{getwd}}.}

\item{ignore.case}{[\code{logical(1)}]\cr
Should path comparisons be made case insensitve?
Default is \code{TRUE} on Windows systems and \code{FALSE} on other systems.}
}
\value{
[character(1)]: A relative path.
}
\description{
Constructs a relative path from path \code{from} to path \code{to}.
If this is not possible (i.e. different drive letters on windows systems),
\code{NA} is returned.
}

