% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_barplot_monthly_stats.R
\name{get_barplot_monthly_stats}
\alias{get_barplot_monthly_stats}
\title{Barplots with monthly stats}
\usage{
get_barplot_monthly_stats(df_stats, team, player, title, nrow_facet)
}
\arguments{
\item{df_stats}{Data frame with the statistics.}

\item{team}{Team.}

\item{player}{Player.}

\item{title}{Plot title.}

\item{nrow_facet}{Number of facet rows.}
}
\value{
Graphical device
}
\description{
In all the available basketball websites, the stats are presented for the whole
number of games played. This function represents a barplot with the players' stats 
for each month, which is very useful to analyse the players' evolution.
}
\examples{
\dontrun{
library(dplyr)
compet <- "ACB"
df <- do_join_games_bio(compet, acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)
df2 <- do_stats(df1, "Total", "2017-2018", compet, "Regular Season")

months <- c(df \%>\% distinct(Month))$Month
months_order <- c("September", "October", "November", "December", 
                  "January", "February", "March", "April", "May", "June")
months_plot <- match(months_order, months)
months_plot1 <- months_plot[!is.na(months_plot)]
months_plot2 <- months[months_plot1]

df3 <- data.frame()
for (i in months_plot2) {
 df1_month <- df1 \%>\%
   filter(Month == i)
 df2_month <- do_stats(df1_month, "Total", "2017-2018", compet, "Regular Season") \%>\%
   mutate(Month = i)
 df3 <- bind_rows(df3, df2_month)
}

# For just one player:
player <- "Abalde, Alberto"
get_barplot_monthly_stats(df3, "Valencia", player, 
                          paste(compet, "2017-2018", unique(df3$Type_stats), sep = " "), 2)

# For all teams and players:
teams <- as.character(rev(sort(unique(df2$Team))))
for (i in teams[1:2]) {
  players <- sort(unique(df3[df3$Team == i, "Name"]))
  for (j in players[1:2]) {
    print(get_barplot_monthly_stats(df3, i, j, "ACB 2017-2018", 2))
  }
}
}

}
\seealso{
\code{\link{capit_two_words}}
}
