% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_subscription.R
\docType{class}
\name{az_subscription}
\alias{az_subscription}
\title{Azure subscription class}
\format{
An R6 object of class \code{az_subscription}.
}
\description{
Class representing an Azure subscription.
}
\section{Methods}{

\itemize{
\item \code{new(token, id, ...)}: Initialize a subscription object.
\item \code{list_resource_groups()}: Return a list of resource group objects for this subscription.
\item \code{get_resource_group(name)}: Return an object representing an existing resource group.
\item \code{create_resource_group(name, location)}: Create a new resource group in the specified region/location, and return an object representing it.
\item \code{delete_resource_group(name, confirm=TRUE)}: Delete a resource group, after asking for confirmation.
\item \code{resource_group_exists(name)}: Check if a resource group exists.
\item \code{list_resources()}: List all resources deployed under this subscription.
\item \code{list_locations()}: List locations available.
\item \code{get_provider_api_version(provider, type, which=1, stable_only=TRUE)}: Get the current API version for the given resource provider and type. If no resource type is supplied, returns a vector of API versions, one for each resource type for the given provider. If neither provider nor type is supplied, returns the API versions for all resources and providers. Set \code{stable_only=FALSE} to allow preview APIs to be returned. Set \code{which} to a number > 1 to return an API other than the most recent.
\item \code{do_operation(...)}: Carry out an operation. See 'Operations' for more details.
\item \code{create_lock(name, level)}: Create a management lock on this subscription (which will propagate to all resources within it).
\item \code{get_lock(name)}: Returns a management lock object.
\item \code{delete_lock(name)}: Deletes a management lock object.
\item \code{list_locks()}: List all locks that exist in this subscription.
\item \code{add_role_assignment(name, ...)}: Adds a new role assignment. See 'Role-based access control' below.
\item \code{get_role_assignment(id)}: Retrieves an existing role assignment.
\item \code{remove_role_assignment(id)}: Removes an existing role assignment.
\item \code{list_role_assignments()}: Lists role assignments.
\item \code{get_role_definition(id)}: Retrieves an existing role definition.
\item \code{list_role_definitions()} Lists role definitions.
}
}

\section{Details}{

Generally, the easiest way to create a subscription object is via the \code{get_subscription} or \code{list_subscriptions} methods of the \link{az_rm} class. To create a subscription object in isolation, call the \code{new()} method and supply an Oauth 2.0 token of class \link{AzureToken}, along with the ID of the subscription.
}

\section{Operations}{

The \code{do_operation()} method allows you to carry out arbitrary operations on the subscription. It takes the following arguments:
\itemize{
\item \code{op}: The operation in question, which will be appended to the URL path of the request.
\item \code{options}: A named list giving the URL query parameters.
\item \code{...}: Other named arguments passed to \link{call_azure_rm}, and then to the appropriate call in httr. In particular, use \code{body} to supply the body of a PUT, POST or PATCH request, and \code{api_version} to set the API version.
\item \code{http_verb}: The HTTP verb as a string, one of \code{GET}, \code{PUT}, \code{POST}, \code{DELETE}, \code{HEAD} or \code{PATCH}.
}

Consult the Azure documentation for what operations are supported.
}

\section{Role-based access control}{

AzureRMR implements a subset of the full RBAC functionality within Azure Active Directory. You can retrieve role definitions and add and remove role assignments, at the subscription, resource group and resource levels. See \link{rbac} for more information.
}

\examples{
\dontrun{

# recommended way to retrieve a subscription object
sub <- get_azure_login("myaadtenant")$
    get_subscription("subscription_id")

# retrieve list of resource group objects under this subscription
sub$list_resource_groups()

# get a resource group
sub$get_resource_group("rgname")

# check if a resource group exists, and if not, create it
rg_exists <- sub$resource_group_exists("rgname")
if(!rg_exists)
    sub$create_resource_group("rgname", location="australiaeast")

# delete a resource group
sub$delete_resource_group("rgname")

# get provider API versions for some resource types
sub$get_provider_api_version("Microsoft.Compute", "virtualMachines")
sub$get_provider_api_version("Microsoft.Storage", "storageAccounts")

}
}
\seealso{
\href{https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-group-overview}{Azure Resource Manager overview}

For role-based access control methods, see \link{rbac}

For management locks, see \link{lock}
}
