% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore.R
\name{AutoScore_rank}
\alias{AutoScore_rank}
\title{AutoScore STEP(i): Rank variables with machine learning (AutoScore Module 1)}
\usage{
AutoScore_rank(train_set, ntree = 100)
}
\arguments{
\item{train_set}{A processed \code{data.frame} that contains data to be analyzed, for training.}

\item{ntree}{Number of trees in the random forest (Default: 100).}
}
\value{
Returns a vector containing the list of variables and its ranking generated by machine learning (random forest)
}
\description{
AutoScore STEP(i): Rank variables with machine learning (AutoScore Module 1)
}
\details{
The first step in the AutoScore framework is variable ranking. We use random forest (RF),
an ensemble machine learning algorithm, to identify the top-ranking predictors for subsequent score generation.
This step correspond to Module 1 in the AutoScore paper.
}
\examples{
# see AutoScore Guidebook for the whole 5-step workflow
data("sample_data")
names(sample_data)[names(sample_data) == "Mortality_inpatient"] <- "label"
ranking <- AutoScore_rank(sample_data, ntree = 50)
}
\references{
\itemize{
 \item{Breiman, L. (2001), Random Forests, Machine Learning 45(1), 5-32}
 \item{Xie F, Chakraborty B, Ong MEH, Goldstein BA, Liu N. AutoScore: A Machine Learning-Based Automatic Clinical Score Generator and
  Its Application to Mortality Prediction Using Electronic Health Records. JMIR Medical Informatics 2020;8(10):e21798}
}
}
\seealso{
\code{\link{AutoScore_parsimony}}, \code{\link{AutoScore_weighting}}, \code{\link{AutoScore_fine_tuning}}, \code{\link{AutoScore_testing}}, Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.
}
