% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.WordCloud}
\alias{Plot.WordCloud}
\title{Plot.WordCloud}
\usage{
Plot.WordCloud(
  dt = NULL,
  YVar = NULL,
  Height = NULL,
  Width = NULL,
  Title = "Word Cloud",
  EchartsTheme = "macarons",
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = "#63aeff",
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  xaxis.fontSize = 14,
  yaxis.fontSize = 14,
  xaxis.rotate = 0,
  yaxis.rotate = 0,
  ContainLabel = TRUE,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{YVar}{Y-Axis variable name}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{= "Density Plot"}

\item{EchartsTheme}{"auritus","azul","bee-inspired","blue","caravan","carp","chalk","cool","dark-bold","dark","eduardo", "essos","forest","fresh-cut","fruit","gray","green","halloween","helianthus","infographic","inspired", "jazz","london","dark","macarons","macarons2","mint","purple-passion","red-velvet","red","roma","royal", "sakura","shine","tech-blue","vintage","walden","wef","weforum","westeros","wonderland"}

\item{TextColor}{"white",}

\item{title.fontSize}{22}

\item{title.fontWeight}{"bold"}

\item{title.textShadowColor}{'#63aeff'}

\item{title.textShadowBlur}{3}

\item{title.textShadowOffsetY}{1}

\item{title.textShadowOffsetX}{-1}

\item{xaxis.fontSize}{14}

\item{yaxis.fontSize}{14}

\item{xaxis.rotate}{0}

\item{yaxis.rotate}{0}

\item{ContainLabel}{TRUE}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
WordCloud plots
}
\examples{
# Create fake data
dt <- FakeDataGenerator(AddComment = TRUE)

# Create plot
AutoPlots::Plot.WordCloud(
  dt = dt,
  YVar = "Comment",
  Height = NULL,
  Width = NULL,
  Title = "Word Cloud",
  EchartsTheme = "macarons",
  TextColor = "black",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = '#63aeff',
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  xaxis.fontSize = 14,
  yaxis.fontSize = 14,
  xaxis.rotate = 0,
  yaxis.rotate = 0,
  ContainLabel = TRUE,
  Debug = FALSE)

}
\seealso{
Other Standard Plots: 
\code{\link{Plot.ACF}()},
\code{\link{Plot.Area}()},
\code{\link{Plot.BarPlot3D}()},
\code{\link{Plot.Bar}()},
\code{\link{Plot.Box}()},
\code{\link{Plot.Copula3D}()},
\code{\link{Plot.Copula}()},
\code{\link{Plot.CorrMatrix}()},
\code{\link{Plot.Density}()},
\code{\link{Plot.Donut}()},
\code{\link{Plot.HeatMap}()},
\code{\link{Plot.Histogram}()},
\code{\link{Plot.Line}()},
\code{\link{Plot.PACF}()},
\code{\link{Plot.Parallel}()},
\code{\link{Plot.Pie}()},
\code{\link{Plot.ProbabilityPlot}()},
\code{\link{Plot.Radar}()},
\code{\link{Plot.River}()},
\code{\link{Plot.Rosetype}()},
\code{\link{Plot.Scatter3D}()},
\code{\link{Plot.Scatter}()},
\code{\link{Plot.StackedBar}()},
\code{\link{Plot.Step}()}
}
\concept{Standard Plots}
