% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatch.R
\name{summary.inDep}
\alias{summary.inDep}
\alias{plot.inDep}
\title{S3 methods for `inDep`}
\usage{
\method{summary}{inDep}(object, ...)

\method{plot}{inDep}(x, ..., which = 1:5, border = "black", buffer = 0.01)
}
\arguments{
\item{object}{`inDep` object to summarize}

\item{...}{additional arguments to pass on to the method}

\item{x}{object with class `inDep`}

\item{which}{indices of binnings to display from `x`, where
binnings are ordered by increasing p-value}

\item{border}{colour of borders to be drawn on the binnings}

\item{buffer}{relative width of empty space separating categories}
}
\value{
Nothing for the plot method, while summary quietly returns
a summary of `inDep`
}
\description{
The `summary` and `plot` methods outlined here
support the quick description of an `inDep` object.
}
\details{
Methods

For each index in `which`, this function produces a row
of three plots. The first plot is the raw data, the second plot
is the ranks of the data, and the final plot is the binning
contained in the `inDep` object.
}
\section{Functions}{
\itemize{
\item \code{summary(inDep)}: Summary method for `inDep`

\item \code{plot(inDep)}: Plot method for `inDep`

}}
\author{
Chris Salahub
}
