% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitters.R
\name{halfSplit}
\alias{halfSplit}
\title{Halve at an observed point}
\usage{
halfSplit(bin, margin = "x")
}
\arguments{
\item{bin}{a bin to be split with elements `x`, `y`, `depth`,
`bnds` (list with elements `x` and `y`), `expn`, `n`}

\item{margin}{string, one of `x` or `y`}
}
\value{
A list of two bins resulting from the split of `bin` in
half along the specified margin
}
\description{
This function halves a bin under the restriction that
splits can only occur at observation coordinates.
}
\details{
Given a bin and a margin, this function splits the bin so
half the points are above the new split point and half are below.
}
\examples{
bin <- list(x = 1:10, y = sample(1:10),
            bnds = list(x = c(0, 10), y = c(0, 10)),
            expn = 10, n = 10, depth = 0)
halfSplit(bin)
halfSplit(bin, margin = "y")
}
\author{
Chris Salahub
}
