% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tactical_RAA.R
\name{tactical_RAA}
\alias{tactical_RAA}
\title{Returns allocations for the Robust Asset Allocation on a given date}
\usage{
tactical_RAA(strat, reb_date, P, R, risk_free)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free
asset, or a scalar numeric with the annual risk-free rate in decimals.}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{tactical_RAA} determines asset allocations for a strategy according to
the Robust Asset Allocation (RAA) approach of Gray and Vogel (2015,
ISBN:978-1119071501).
}
\details{
RAA uses two trend-following rules. The first one is based on comparing the
current price of assets with their 12-month moving average. The second one
compares returns with the returns of the risk-free asset. The allocation rule
keeps either 100%, 50%, or 0% of the default weight for each risky asset
if both rules provide a positive signal, only one rule provided a positive
signal, or both rules provide a negative signal, respectively. Any amounts
not allocated to risky assets are allocated to the risk-free asset as
implemented in the \code{backtest_allocation} function.
}
\examples{
raa  <- asset_allocations$tactical$raa
reb_date <- as.Date("2022-03-31")
tactical_RAA(raa,
             reb_date,
             ETFs$Prices[, raa$tickers],
             ETFs$Returns[, raa$tickers],
             ETFs$risk_free)
}
