% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_from_tickers.R
\name{get_data_from_tickers}
\alias{get_data_from_tickers}
\title{Downloads prices in xts format from a list of tickers from Yahoo Finance (<https://finance.yahoo.com/>).}
\usage{
get_data_from_tickers(tickers, starting_date = "2007-01-01")
}
\arguments{
\item{tickers}{A vector containing a tickers.}

\item{starting_date}{A date on which the allocation rule is applied.}
}
\value{
An object of class \code{"List"} containing two objects of class
\code{"xts"} with respectively the prices and returns of the assets,
with column names corresponding to the tickers.
}
\description{
\code{get_data_from_tickers} retrieves adjusted closing prices from Yahoo Finance
for a set of tickers and returns the prices and returns.
}
\details{
The function retrieves data from Yahoo Finance (<https://finance.yahoo.com/>)
using the getSymbols function from the \code{quantmod} package. It calculates
returns from adjusted prices. The ticker names must correspond to those found
in Yahoo Finance.
}
\examples{
## download data for the following exchange-traded-funds: MTUM, VLUE, USMV, and QUAL.
factor_ETFs <- get_data_from_tickers(c("MTUM", "VLUE", "USMV", "QUAL"),
                                     starting_date = "2020-01-01")
}
