% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/phases.R
\docType{methods}
\name{phases}
\alias{phases}
\alias{phases-method}
\alias{phases,EventsMCMC,missing-method}
\alias{phases,EventsMCMC,list-method}
\title{Compute Phases}
\usage{
phases(x, groups, ...)

\S4method{phases}{EventsMCMC,missing}(x)

\S4method{phases}{EventsMCMC,list}(x, groups)
}
\arguments{
\item{x}{An \code{\linkS4class{EventsMCMC}}.}

\item{groups}{A \code{\link{list}} of (named) vector of names or indexes of columns in
\code{x} (see \code{\link[=phases]{phases()}}).}

\item{...}{Currently not used.}
}
\value{
A \code{\linkS4class{PhasesMCMC}} object.
}
\description{
Constructs the minimum and maximum for a group of events (phase).
}
\note{
The default value of \code{start} or \code{end} corresponds to a CSV file exported
from \href{https://chronomodel.com/}{ChronoModel}.
}
\examples{
## Coerce to phases
(pha <- as_phases(mcmc_phases, start = c(1, 3), calendar = CE(), iteration = 1))
summary(pha, calendar = CE())

## Plot phases
plot(pha)
plot(pha, succession = "hiatus")
plot(pha, succession = "transition")

## Compute phases from events
(eve <- as_events(mcmc_events, calendar = CE(), iteration = 1))

## Compute min-max range for all chains
pha1 <- phases(eve)
summary(pha1, calendar = CE())

## Compute min-max range by group
pha2 <- phases(eve, groups = list(phase_1 = c(1, 3), phase_2 = c(2, 4)))
summary(pha2, calendar = CE())


zz <- pha@.Data
head(zz)

head(zz[, 1, ])

head(pha)
}
\seealso{
Other phase tools: 
\code{\link{duration}()}
}
\author{
A. Philippe, M.-A. Vibet, N. Frerebeau
}
\concept{phase tools}
