% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiCredibleInterval.R
\name{MultiCredibleInterval}
\alias{MultiCredibleInterval}
\title{Bayesian credible interval for a series of dates}
\usage{
MultiCredibleInterval(data, position, level = 0.95, roundingOfValue = 0)
}
\arguments{
\item{data}{data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest.}

\item{level}{Probability corresponding to the level of confidence used
for the credible interval.}

\item{roundingOfValue}{Integer indicating the number of decimal places.}
}
\value{
Returns a matrix of values containing the level of confidence and the endpoints of
the shortest credible interval for each variable of the MCMC chain. The name of the
resulting rows are the positions of the corresponding columns in the CSV file. The
result is given in calendar years (BC/AD).
}
\description{
Estimation of the shortest credible interval for each variable of a simulated Markov chain
}
\details{
A \eqn{(100 * level)}\\% credible interval is an interval that keeps \eqn{N * (1 -level)} elements of the sample outside the interval.
The \eqn{(100*level)}\\% credible interval is the shortest of the intervals
}
\examples{
  data(Events)
  MultiCredibleInterval(Events, c(2, 4, 3), 0.95)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
