% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Classes.R
\name{reproduce.archaeophases_mcmc}
\alias{reproduce.archaeophases_mcmc}
\title{Reproduce an MCMC data frame}
\usage{
\method{reproduce}{archaeophases_mcmc}(x, file = NULL, ...)
}
\arguments{
\item{x}{An \code{archaeophases_mcmc} object.}

\item{file}{A path to the original MCMC csv file, or a copy of the file.}

\item{...}{Other parameters.}
}
\description{
Reproduces a data frame from metadata held in an \code{archaeophases_mcmc}
object.
}
\examples{
\dontrun{
x <- read_bcal("http://tsdye.online/AP/bc-1.csv")
y <- reproduce(x)
# TRUE
identical(x, y)
}

}
\seealso{
\code{\link{original_file}}
}
\author{
Thomas S. Dye, \email{tsd@tsdye.online}
}
