#####################################################
#              Import a BCal csv file               #
#####################################################
#' Importing a BCal csv file
#'
#' Importing a csv file containing the output of the MCMC algorithm from the BCal software
#'
#' @param file Name of the CSV file containing the output of the MCMC algorithm.
#' @param bin.width Bin width specified in a BCal project
#' (note: \code{bin.width} does not have to be set if the BCal default bin width of 1 is used).
#'
#' @return A data frame containing a representation of the data in the CSV file
#'
#' @examples
#' \dontrun{
#'   # Import of MCMC generated by BCal and extracted in cal BP (the year of reference is 1950)
#'   data(Fishpond)
#'   write.csv(Fishpond, "fishpond_MCMC.csv", row.names = FALSE)
#'   Fishpond = ImportCSV.BCal("fishpond_MCMC.csv", bin.width = 1)
#'}
#'
#' \dontrun{
#'   # equivalent call
#'   Fishpond2 = ImportCSV("fishpond_MCMC.csv", dec = '.', sep=',', referenceYear = 1950,
#'                         rowToWithdraw = "last", bin.width = 1)
#' }
#' @author Anne Philippe, \email{Anne.Philippe@@univ-nantes.fr},
#' @author Thomas S. Dye, \email{tsd@@tsdye.online}, and
#' @author  Marie-Anne Vibet, \email{Marie-Anne.Vibet@@univ-nantes.fr}
#'
#' @export
ImportCSV.BCal <- function(file, bin.width=NULL) {
  ImportCSV(file = file, iterationColumn = 1, referenceYear = 1950, rowToWithdraw = "last", bin.width = bin.width)
}
