% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{SuccessionPlot}
\alias{SuccessionPlot}
\title{Density Plots of two successive groups (for groups in temporal order constraint)}
\usage{
SuccessionPlot(Phase1Min_chain, Phase1Max_chain, Phase2Min_chain,
  Phase2Max_chain, level = 0.95,
  title = "Characterisation of a succession of groups", 
  exportFile = NULL, exportFormat = "PNG", GridLength = 1024)
}
\arguments{
  \item{Phase1Min_chain}{numeric vector containing the output of the MCMC algorithm for the minimum of the dates included in the oldest phase. The MCMC samples should be in calendar year (BC/AD).}
  \item{Phase1Max_chain}{numeric vector containing the output of the MCMC algorithm for the maximum of the dates included in the oldest phase. The MCMC samples should be in calendar year (BC/AD).} 
  \item{Phase2Min_chain}{numeric vector containing the output of the MCMC algorithm for the minimum of the dates included in the youngest phase. The MCMC samples should be in calendar year (BC/AD).}
  \item{Phase2Max_chain}{numeric vector containing the output of the MCMC algorithm for the maximum of the dates included in the youngest phase. The MCMC samples should be in calendar year (BC/AD).} 
  \item{level}{probability corresponding to the level of confidence}
  \item{title}{title of the graph}
  \item{exportFile}{the name of the file to be saved. If NULL then no graph is saved.}
  \item{exportFormat}{the format of the export file : SVG or PNG.}
  \item{GridLength}{length of the grid used to estimate the density}
}
\value{
Plot of the densities of the minimum and the maximum of the dates included in each phase. The result is given in calendar year (in format BC/AD).
}
\description{
Plot of the densities of the minimum and the maximum of the dates included in each phase and adds several summary statistics (mean, CI, HPDR). The result is given in calendar year (in format BC/AD).
}
\details{
Curves represent the density of the minimum (oldest dates) and the maximum (youngest dates) of the dates included in each phase. Curves of the same color refer to the same phase. Time range intervals are symbolised by segments above the curves drawn using the same color as the one of the curves of the associated phase. Transition and gap range intervals are represented by two-coloured segments using the colors of the both phases in succession. If the gap between the successive phases does not exist, a cross is drawn instead of a segment. 
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases); attach(Phases)
  SuccessionPlot(Phase.1.alpha, Phase.1.beta, Phase.2.alpha, Phase.2.beta, level = 0.95)
  # SuccessionPlot(Phase.1.alpha, Phase.1.beta, Phase.2.alpha, Phase.2.beta, 
  # exportFile = "Succession", exportFormat = "PNG")
}
\keyword{ gap between two phases}
\keyword{ transition between two phases}
\keyword{ phase time range}
\keyword{ temporal order}
\keyword{ marginal posterior density }
\keyword{ succession of phases }
