% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiPhasesTransition}
\alias{MultiPhasesTransition}
\title{Transition range for a succession of phases (for phases in temporal order constraint)}
\usage{
MultiPhasesTransition(data, position_minimum, position_maximum = position_minimum+1, 
level = 0.95)
}
\arguments{
  \item{data}{dataframe containing the output of the MCMC algorithm }
  \item{position_minimum}{numeric vector containing the column number corresponding to the minimum of the dates included in each phase}
  \item{position_maximum}{numeric vector containing the column number corresponding to the maximum of the dates included in each phase. By default, position_maximum = position_minimum + 1. 
}
  \item{level}{probability corresponding to the level of confidence}
}
\value{
Returns a matrix of values containing the level of confidence and the endpoints of the transition interval for each pair of successive phases
}
\description{
Finds if it exists the shortest interval [TransitionRangeInf, TransitionRangeSup] that satisfies : P(TransitionRangeInf < Phase1Max < Phase2Min < TransitionRangeSup | M) = level for each phase
}
\details{
For each i, MultiPhasesTransition computes the transition interval for the phase defined by its minimum position_minimum[i] and its maximum position_maximum[i]. 
The default value of position_maximum corresponds to CSV files exported from ChronoModel software. 
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  
  # List of the name of the phases 
  names(Phases)
  
  # Stipulating position_maximum
  MultiPhasesTransition(Phases, c(4,2), c(5,3))
  
  # In this case, equivalent to 
  MultiPhasesTransition(Phases, c(4,2))

}
\keyword{ transition between two phases }
\keyword{ temporal order }
\keyword{ succession of phases }