% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_functions.R
\name{per_cluster_df}
\alias{per_cluster_df}
\title{per_cluster_df}
\usage{
per_cluster_df(
  seurat_object,
  assay = "influence",
  cluster_id = "seurat_clusters"
)
}
\arguments{
\item{seurat_object}{seurat object}

\item{assay}{assay containing influence or motif scores generated from cluster pseudobulk}

\item{cluster_id}{ID used for finding clusters of cells}
}
\value{
dataframe with assay scores, concatinating cells from each per cluster
}
\description{
generate a table of the assay score averages per cluster identifier cell
}
\examples{
sce_small <- readRDS(system.file("extdata","sce_small.Rds",package = 'AnanseSeurat'))
df <- per_cluster_df(sce_small)
}
