% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{getTrace}
\alias{getTrace}
\title{extracts an object of traces from a parameter object.}
\usage{
getTrace(parameter)
}
\arguments{
\item{parameter}{A Parameter object that corresponds to one of the model types.}
}
\value{
trace Returns an object of type Trace extracted from the given parameter object
}
\description{
extracts an object of traces from a parameter object.
}
\examples{
 
genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- c(1,1)
numMixtures <- 2
geneAssignment <- c(rep(1,floor(length(genome)/2)),rep(2,ceiling(length(genome)/2)))
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")

trace <- getTrace(parameter) # empty trace object since no MCMC was perfomed

}
