# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name setRestartFileSettings
#' @title setRestartFileSettings
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Set restart file output name and frequency prior to running MCMC
#' @param filename name of restart file
#' @param interval number of samples (ie. iterations * thinning) between writing new restart file
#' @param multiple if true, will output a new restart file at each interval (file name will include sample it was written at)
NULL

#' @name setStepsToAdapt
#' @title setStepsToAdapt
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Set number of iterations (total iterations = samples * thinning) to allow proposal widths to adapt
#' @param steps a postive value
NULL

#' @name getStepsToAdapt
#' @title getStepsToAdapt
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Return number of iterations (total iterations = samples * thinning) to allow proposal widths to adapt
#' @return number of sample steps to adapt
NULL

#' @name getLogPosteriorTrace 
#' @title getLogPosteriorTrace 
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Returns the logPosterior trace
#' @return vector representing logPosterior trace
NULL

#' @name getLogLikelihoodTrace
#' @title getLogLikelihoodTrace
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Returns the logLikelihood trace
#' @return vector representing logLikelihood trace
NULL

#' @name getLogPosteriorMean
#' @title getLogPosteriorMean
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Calculate the mean log posterior probability over the last n samples
#' @param samples postive value less than total length of the MCMC trace
#' @return mean logPosterior
NULL

#' @name getSamples
#' @title getSamples 
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Return number of samples set for MCMCAlgorithm object
#' @return number of samples used during MCMC
NULL

#' @name getThinning
#' @title getThinning 
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Return thinning value, which is the number of iterations (total iterations = samples * thinning) not being kept
#' @return thinning value used during MCMC
NULL

#' @name getAdaptiveWidth
#' @title getAdaptiveWidth
#' @description Return sample adaptiveWidth value, which is the number of samples (not iterations) between adapting parameter proposal widths
#' @return number of sample steps between adapting proposal widths
NULL

#' @name setSamples
#' @title setSamples
#' @description Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Set number of samples set for MCMCAlgorithm object
#' @param _samples postive value
NULL

#' @name setThinning
#' @title setThinning
#' @description  Set thinning value, which is the number of iterations (total iterations = samples * thinning) not being kept
#' @param _thinning postive value
NULL

#' @name setAdaptiveWidth
#' @title setAdaptiveWidth
#' @description  Method of MCMC class (access via mcmc$<function name>, where mcmc is an object initialized by initializeMCMCObject). Set sample adaptiveWidth value, which is the number of samples (not iterations) between adapting parameter proposal widths
#' @param _adaptiveWidth postive value
NULL

#' @name simulateGenome
#' @title simulateGenome
#' @description Method of Model class (access via model$<function name>, where model is an object initialized by initializeModelObject). Will simulate a version of the given genome using the current set of parameters stored in the Parameter object. This can be written to a FASTA file using genome$writeFasta(<filename>,simulated = TRUE).
#' @param genome a Genome object initialized by initializeGenomeObject
NULL

#' @name readPhiValue
#' @title readPhiValue
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Read synthesis rate values from file. File should be two column file <gene_id,phi> and is expected to have a header row
#' @param filename name of file to be read
NULL

#' @name setGroupList
#' @title setGroupList
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Set amino acids (ROC, FONSE) or codons (PA, PANSE) for which parameters will be estimated. Note that non-default groupLists are still in beta testing and should be used with caution.
#' @param List of strings epresenting groups for parameters to be estimated. Should be one letter amino acid (ROC, FONSE) or list of sense codons (PA, PANSE). 
NULL

#' @name getGroupList
#' @title getGroupList
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Get amino acids (ROC, FONSE) or codons (PA, PANSE) for which parameters will be estimated
#' @return returns list of amino acids or codons
NULL

#' @name getTraceObject
#' @title getTraceObject
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Get Trace object stored by a Parameter object. Useful for plotting certain parameter traces.
#' @return Trace object
NULL

#' @name initializeSynthesisRateByGenome
#' @title initializeSynthesisRateByGenome
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Initialize synthesis rates using SCUO values calcuated from the genome
#' @param genome a Genome object
NULL

#' @name initializeSynthesisRateByRandom
#' @title initializeSynthesisRateByRandom
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Initialize synthesis rates by drawing a from a lognormal distribution with mean = -(sd_phi)^2/2 and sd = sd_phi
#' @param sd_phi a positive value which will be the standard deviation of the lognormal distribution
NULL

#' @name initializeSynthesisRateByList
#' @title initializeSynthesisRateByList
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Initialize synthesis rates with values passed in as a list
#' @param expression a list of values to use as initial synthesis rate values. Should be same size as number of genes in genome.
NULL

#' @name getSynthesisRate
#' @title getSynthesisRate
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Get current synthesis rates for all genes and all mixtures 
#' @return 2 by 2 vector of numeric values
NULL

#' @name getSynthesisRatePosteriorMeanForGene
#' @title getSynthesisRatePosteriorMeanForGene
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Get posterior mean synthesis rate value for a gene
#' @param samples number of samples over which to calculate mean
#' @param geneIndex corresponding index of gene in genome for which posterior mean synthesis rate will be calculated. Should be a number between 1 and length(genome) 
#' @param log_scale Calculate posterior mean on log scale
#' @return posterior mean synthesis rate for gene
NULL

#' @name getSynthesisRatePosteriorVarianceForGene
#' @title getSynthesisRatePosteriorVarianceForGene
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Get synthesis rate variance for a gene
#' @param samples number of samples over which to calculate variance
#' @param geneIndex corresponding index of gene in genome for which synthesis rate variance will be calculated. Should be a number between 1 and length(genome) 
#' @param unbiased Should calculate variance using unbiased (N-1) or biased (N) correction
#' @param log_scale Calculate variance on log scale
#' @return posterior mean synthesis rate for gene
NULL

#' @name getEstimatedMixtureAssignmentForGene
#' @title getEstimatedMixtureAssignmentForGene
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Get estimated mixture assignment for gene
#' @param samples number of samples over which to calculate mixture assignment
#' @param geneIndex corresponding index of gene in genome. Should be a number between 1 and length(genome). 
#' @return returns value between 1 and n, where n is number of mixtures
NULL

#' @name getEstimatedMixtureAssignmentProbabilitiesForGene
#' @title getEstimatedMixtureAssignmentProbabilitiesForGene
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Get estimated mixture assignment probabilities for gene
#' @param samples number of samples over which to calculate mixture assignment probabilities
#' @param geneIndex corresponding index of gene in genome. Should be a number between 1 and length(genome). 
#' @return returns vector of probabilities representing mixture probabilities for gene
NULL

#' @name getStdDevSynthesisRatePosteriorMean
#' @title getStdDevSynthesisRatePosteriorMean
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Calculate posterior mean of standard deviation parameter of lognormal describing distribution of synthesis rates
#' @param samples number of samples over which to calculate posterior mean
#' @param mixture mixture index to use. Should be number between 0 and n-1, where n is number of mixtures
#' @return returns posterior mean for standard deviation of lognormal distribution of synthesis rates
NULL

#' @name getStdDevSynthesisRateVariance
#' @title getStdDevSynthesisRateVariance
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Calculate variance of standard deviation parameter of lognormal describing distribution of synthesis rates
#' @param samples number of samples over which to calculate variance
#' @param mixture mixture index to use. Should be number between 0 and n-1, where n is number of mixtures
#' @param unbiased If TRUE, should calculate variance using unbiased (N-1). Otherwise, used biased (N) correction
#' @return returns variance for standard deviation of lognormal distribution of synthesis rates
NULL

#' @name getCodonSpecificPosteriorMeanForCodon
#' @title getCodonSpecificPosteriorMeanForCodon
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Calculate codon-specific parameter (CSP) posterior mean
#' @param mixtureElement mixture to calculate CSP posterior mean. Should be between 1 and n, where n is number of mixtures.
#' @param samples number of samples to use for calculating posterior mean
#' @param codon codon to calculate CSP
#' @param paramType CSP to calculate posterior mean for. 0: Mutation (ROC,FONSE) or Alpha (PA, PANSE). 1: Selection (ROC,FONSE), Lambda (PANSE), Lambda^prime (PA). 2: NSERate (PANSE) 
#' @param withoutReference If model uses reference codon, then ignore this codon (fixed at 0). Should be TRUE for ROC and FONSE. Should be FALSE for PA and PANSE.
#' @param log_scale If true, calculate posterior mean on log scale. Should only be used for PA and PANSE.
#' @return posterior mean value for CSP
NULL

#' @name getCodonSpecificPosteriorVarianceForCodon
#' @title getCodonSpecificPosteriorVarianceForCodon
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Calculate codon-specific parameter (CSP) variance
#' @param mixtureElement mixture to calculate CSP variance. Should be between 1 and n, where n is number of mixtures.
#' @param samples number of samples to use for calculating variance
#' @param codon codon to calculate CSP
#' @param paramType CSP to calculate variance for. 0: Mutation (ROC,FONSE) or Alpha (PA, PANSE). 1: Selection (ROC,FONSE), Lambda (PANSE), Lambda^prime (PA). 2: NSERate (PANSE) 
#' @param unbiased If TRUE, should calculate variance using unbiased (N-1). Otherwise, used biased (N) correction
#' @param withoutReference If model uses reference codon, then ignore this codon (fixed at 0). Should be TRUE for ROC and FONSE. Should be FALSE for PA and PANSE.
#' @param log_scale If true, calculate posterior mean on log scale. Should only be used for PA and PANSE.
#' @return variance over trace for CSP
NULL

#' @name getCodonSpecificQuantilesForCodon
#' @title getCodonSpecificQuantilesForCodon
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Calculate quantiles of CSP traces
#' @param mixtureElement mixture to calculate CSP variance. Should be between 1 and n, where n is number of mixtures.
#' @param samples number of samples to use for calculating variance
#' @param codon codon to calculate CSP
#' @param paramType CSP to calculate variance for. 0: Mutation (ROC,FONSE) or Alpha (PA, PANSE). 1: Selection (ROC,FONSE), Lambda (PANSE), Lambda^prime (PA). 2: NSERate (PANSE) 
#' @param probs vector of two doubles between 0 and 1 indicating range over which to calculate quantiles. <0.0275, 0.975> would give 95\% quantiles.
#' @param withoutReference If model uses reference codon, then ignore this codon (fixed at 0). Should be TRUE for ROC and FONSE. Should be FALSE for PA and PANSE.
#' @param log_scale If true, calculate posterior mean on log scale. Should only be used for PA and PANSE.
#' @return vector representing lower and upper bound of quantile
NULL

#' @name getNoiseOffsetPosteriorMean
#' @title getNoiseOffsetPosteriorMean
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Calculate posterior mean of standard deviation parameter of lognormal describing distribution of synthesis rates
#' @param index mixture index to use. Should be number between 0 and n-1, where n is number of mixtures
#' @param samples number of samples over which to calculate posterior mean
#' @return returns posterior mean for standard deviation of lognormal distribution of synthesis rates
NULL

#' @name getNoiseOffsetVariance
#' @title getNoiseOffsetVariance
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Calculate variance of noise offset parameter used when fitting model with empirical estimates of synthesis rates (ie. withPhi fits)
#' @param index mixture index to use. Should be number between 0 and n-1, where n is number of mixtures
#' @param samples number of samples over which to calculate variance
#' @param unbiased If TRUE, should calculate variance using unbiased (N-1). Otherwise, used biased (N) correction
#' @return returns variance for noise offset
NULL

#' @name fixSphi
#' @title fixSphi
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Fix the value of s_phi (standard deviation of lognormal for synthesis rates) at its current value
NULL

#' @name initMutationCategories
#' @title initMutationCategories
#' @description Initialize values for mutation CSP. File should be of comma-separated with header. Three columns should be of order Amino_acid,Codon,Value
#' @param files list of files containing starting values. Number of files should equal the number of categories.
#' @param numCategories number of mutation categories (should be less than or equal to number of mixtures)
#' @param fix Can use this parameter to fix mutation at current values (won't change over course of MCMC run)
NULL

#' @name initSelectionCategories
#' @title initSelectionCategories
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Initialize values for selection CSP. File should be of comma-separated with header. Three columns should be of order Amino_acid,Codon,Value
#' @param files list of files containing starting values. Number of files should equal the number of categories.
#' @param numCategories number of mutation categories (should be less than or equal to number of mixtures)
#' @param fix Can use this parameter to fix selection at current values (won't change over course of MCMC run)
NULL

#' @name fixDM
#' @title fixDM
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Fix the value of mutation its current value
NULL

#' @name fixDEta
#' @title fixDEta
#' @description Method of Parameter class (access via parameter$<function name>, where parameter is an object initialized by initializeParameterObject). Fix the value of selection its current value
NULL

