% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{ilbm8lores.iff}
\alias{ilbm8lores.iff}
\title{An example file of a bitmap image stored in the Interchange File Format}
\format{
{
See \code{\link[=IFFChunk-class]{IFFChunk-class()}} and references for more information
about the Interchange File Format.}
}
\description{
This file is provided to demonstrate the structure of an Interchange File
Format and is used in several examples throughout this package.
}
\details{
The Interchange File Format stores information compartmentally in separate
containers called 'chunks'. This file demonstrates how a bitmap image
is stored in this format. In addition to the raw bitmap data, the file
also contains meta-information on the bitmap dimensions, its colour palette and
the display mode that should be used on an Amiga. See also
\code{\link[=interpretIFFChunk]{interpretIFFChunk()}}, \code{\link[=IFFChunk-class]{IFFChunk-class()}}
and the example for \code{\link[=bitmapToRaster]{bitmapToRaster()}}.
}
\examples{
\dontrun{
filename <- system.file("ilbm8lores.iff", package = "AmigaFFH")
example.iff <- read.iff(filename)

## show the structure of the IFF file:
print(example.iff)
}
}
\references{
\url{https://en.wikipedia.org/wiki/Interchange_File_Format}

\url{https://wiki.amigaos.net/wiki/A_Quick_Introduction_to_IFF}
}
