% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_configuration.r
\docType{class}
\name{SysConfig}
\alias{SysConfig}
\title{The S3 SysConfig class}
\description{
A comprehensive representation of an Amiga system-configuration file.
}
\details{
The system-configuration file is a binary file stored in the `devs' folder
of the root of a bootable Amiga DOS device, containing system preferences.
It was used in Amiga OS 1.x. Although it could be used in later versions, it was
gradually phased out and some settings may not be usable in the later versions.
See references below for more details.

Definitions of the system-configuration have file been revised at some points.
Revisions are minor and usually targetted at backward compatibility. Here
revision V38.2 (released on 16 September 1992) is implemented, which is the
latest documented version.

The sytem-configuration file contains settings for the serial and parallel
port and the printer. It also contains some settings for the `workbench'
which was the Amiga equivalent of what is now mostly known as the computers desktop.
Colours for the workbench and the shape of the mouse pointer are also stored
in this file. Settings for the mouse and basic screen resolution are also part
of the file.

The SysConfig object is a comprehensive representation of the binary
system-configuration file. It is a a \code{list} where the elements have identical
names as listed in the documents provided the references. The names are usually
self-explenatory, but the referred documents can also be
consulted to obtain more detailed information with respect to each of
these elements. The mouse pointer is included as a \code{\link{hardwareSprite}} object
in the list. The pointer image can be replaced by a different \code{\link{hardwareSprite}},
but make sure it has an height of 16 pixels.

It is possible to change the values of the list, but not all values may be valid.
Note that they will not be fully checked for validity. Invalid values may result in errors
when writing to a binary file using \code{\link{write.SysConfig}}, or may simply not
work properly on an Amiga or in an emulator.

Use \code{\link{simpleSysConfig}} for creating a simple SysConfig object which can
be modified. Use \code{\link{read.SysConfig}} to read, and \code{\link{write.SysConfig}}
to write system-configuration files. With \code{\link{rawToSysConfig}} and
\code{\link[AmigaFFH]{as.raw}} SysConfig can be coerced back and forth from and to
its raw (binary) form.
}
\references{
\url{http://wiki.amigaos.net/wiki/Preferences#Preferences_in_1.3_and_Older_Versions_of_the_OS}
\url{http://amigadev.elowar.com/read/ADCD_2.1/Includes_and_Autodocs_2._guide/node00D5.html}
\url{http://amigadev.elowar.com/read/ADCD_2.1/Includes_and_Autodocs_3._guide/node063B.html}
}
\seealso{
Other SysConfig.operations: \code{\link{rawToSysConfig}},
  \code{\link{read.SysConfig}},
  \code{\link{simpleSysConfig}},
  \code{\link{write.SysConfig}}
}
\author{
Pepijn de Vries
}
