% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_load.R
\name{pat_load}
\alias{pat_load}
\title{Load PurpleAir time series data for a time period}
\usage{
pat_load(
  id = NULL,
  label = NULL,
  pas = NULL,
  startdate = NULL,
  enddate = NULL,
  timezone = "America/Los_Angeles"
)
}
\arguments{
\item{id}{PurpleAir sensor 'deviceDeploymentID'.}

\item{label}{PurpleAir sensor 'label'.}

\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{startdate}{Desired start time (ISO 8601) or \code{POSIXct}.}

\item{enddate}{Desired end time (ISO 8601) or \code{POSIXct}.}

\item{timezone}{Timezone used to interpret start and end dates.}
}
\value{
A PurpleAir Timeseries \emph{pat} object.
}
\description{
A pre-generated PurpleAir Timeseries \emph{pat} object will be 
loaded for the given time interval if available. Data are 
loaded from the archive set with either \code{setArchiveBaseUrl()} or 
\code{setArchiveBaseDir()} for locally archived files.

Dates can be anything that is understood by 
\code{MazamaCoreUtils::parseDatetime()} including any of the following 
recommended formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
\item{\code{"YYYY-mm-dd HH:MM:SS"}}
}

When no dates are specified, \code{pat_loadLatest()} is used, loading data
for the last 7 days.
}
\note{
Archive file names are 
generated with a unique "device-deployment" identifier by combining a unique 
location ID with a unique device ID. These "device-deployment" identifiers 
guarantee that movement of a sensor will result in the creation of a new
time series.

Users may request a \emph{pat} object in one of two ways:

1) Pass in \code{id} with a valid a \code{deviceDeploymentID}

2) Pass in both \code{label} and \code{pas} so that the 
\code{deviceDeploymentID} can be looked up.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

# Reference an older 'pas' before this sensor was dropped
pas <- pas_load(20190901, archival = TRUE)

pat <- pat_load(
  label = "SCNP_20", 
  pas = pas,
  startdate = 20190411, 
  enddate = 20190521
)

pat_multiPlot(pat)
}
}
\seealso{
\link{pat_loadLatest}

\link{pat_loadMonth}

\link{pat_createNew}
}
