% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-paTimeseries.R
\name{pat_isPat}
\alias{pat_isPat}
\title{Test for correct structure in a \emph{pat} object}
\usage{
pat_isPat(pat = NULL)
}
\arguments{
\item{pat}{\emph{pat} object}
}
\value{
\code{TRUE} if \code{pat} has the correct structure, \code{FALSE} otherwise.
}
\description{
The \code{pat} is checked for the 'pat' class name
and presence of core \code{meta} and \code{data} columns.

Core \code{meta} columns include:

\itemize{
  \item{\code{ID} -- Purple Air ID}
  \item{\code{label} -- location label}
  \item{\code{sensorType} -- PurpleAir sensor type}
  \item{\code{longitude} -- decimal degrees E}
  \item{\code{latitude} -- decimal degrees N}
  \item{\code{timezone} -- Olson timezone}
  \item{\code{countryCode} -- ISO 3166-1 alpha-2}
  \item{\code{stateCode} -- ISO 3166-2 alpha-2}
  \item{\code{pwfsl_closestDistance} -- distance in meters from an official monitor}
  \item{\code{pwfsl_closestMonitorID} -- identifer for the nearest official monitor}
}

The "pwfsl", official, monitors are obtained from the USFS AirFire site 
using the \pkg{PWFSLSmoke} R package.

Core \code{data} columns include:

\itemize{
\item{\code{datetime} -- measurement time (UTC)}
\item{\code{pm25_A} -- A channel PM 2.5 concentration (ug/m3)}
\item{\code{pm25_B} -- B channel PM 2.5 concentration (ug/m3)}
\item{\code{temperature} -- temperature (F)}
\item{\code{humidity} -- relative humidity (\%)}
}

The "pwfsl", official, monitors are obtained from the USFS AirFire site 
using the \pkg{PWFSLSmoke} R package.
}
\examples{
pat_isPat(example_pat)

}
\keyword{pat}
