% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_filterDatetime.R
\name{pat_filterDatetime}
\alias{pat_filterDatetime}
\title{Datetime filtering for PurpleAir Timeseries objects}
\usage{
pat_filterDatetime(
  pat = NULL,
  startdate = NULL,
  enddate = NULL,
  timezone = NULL
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{startdate}{Desired start datetime (ISO 8601) or \code{POSIXct}.}

\item{enddate}{Desired end datetime (ISO 8601) or \code{POSIXct}.}

\item{timezone}{Olson timezone used to interpret dates.}
}
\value{
A subset of the given \emph{pat} object.
}
\description{
Subsets a PurpleAir Timeseries object by datetime. This function
allows for sub-day filtering as opposed to \code{pat_filterDate()} which
always filters to day-boundaries.

Datetimes can be anything that is understood by 
\code{MazamaCoreUtils::parseDatetime()}. For non-\code{POSIXct} values,
the recommended format is \code{"YYYY-mm-dd HH:MM:SS"}.

Timezone determination precedence assumes that if you are passing in
POSIXct times then you know what you are doing.

\enumerate{
\item{get timezone from \code{startdate} if it is \code{POSIXct}}
\item{use passed in \code{timezone}}
\item{get timezone from \code{pat}}
}
}
\examples{
library(AirSensor)

example_pat \%>\%
  pat_filterDatetime(
    startdate = "2018-08-08 06:00:00", 
    enddate = "2018-08-14 18:00:00"
  ) \%>\%
  pat_multiPlot()

}
\seealso{
\link{pat_filter}

\link{pat_filterDate}
}
