% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_dailySoHIndex_00.R
\name{pat_dailySoHIndex_00}
\alias{pat_dailySoHIndex_00}
\title{State of Health index plot}
\usage{
pat_dailySoHIndex_00(
  pat = NULL,
  minPctReporting = 50,
  breaks = c(0, 0.2, 0.8, 1)
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{minPctReporting}{Percent reporting threshold for A and B channels.}

\item{breaks}{Breaks used to convert index values into index bins.}
}
\description{
This function calculates the \code{pat_dailySoH} function and
returns a tibble containing a state of health index for each day of the
\code{pat} provided. The returned tibble contains columns: \code{datetime},
\code{index}, and \code{index_bin}.

The \code{index} column contains a value normalized between
0 and 1 where 0 represents low confidence in the sensor data and 1 represents
high confidence. The \code{index_bin} is one of 1, 2, or 3 and represents
poor, fair, and good data respectively.

The \code{index} is calculated in the following manner:

\enumerate{
\item{If the A or B channel percent reporting is < \code{minPctReporting}, \code{index = 0}}
\item{Otherwise, \code{index = pm25_A_pm25_B_rsquared}}
}

The \code{breaks} are used to convert \code{index} into the \code{index_bin}
poor-fair-good values.
}
\examples{
\donttest{
library(AirSensor)

tbl <-
  example_pat_failure_A \%>\%
  pat_dailySoHIndex_00()

head(tbl)
}
}
